---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Dependency
  - Constraint
---

# Dependency : Constraint (relation)

> Requires/provides relations; gating and ordering constraints at interfaces.

---

## Definition

- Need/provide pattern
- Gate/order relation
- Require/allow rule
- Flow constraint law

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Need rule | Must have | `Monitor`, `Need` |
| Gate check | Can pass | `Check`, `Gate` |
| Flow order | Step next | `Test`, `Order` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Need rule | Must get | "Needs this" |
| Gate check | Can move | "Way clear" |
| Flow order | Next step | "Then that" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Must have | Must get | How need works |
| Can pass | Can move | How gate flows |
| Step next | Next step | How order forms |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | State need | Force gate |
| Networks | Link must | Node need |
| Cognition | Mind need | Think gate |
| Systems | Flow must | Move need |

---

## Scale Effects

How Dependency manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum need | Wave gate |
| λV | Gate must | State need |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase need | Pattern gate |
| ∇S | Structure must | Clear need |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Wave must | Light need |
| λV | Field gate | Space must |

Note: At extreme scales, dependency faces fundamental limits (e.g., quantum needs at ε, causal gates at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: need clarity
- c: gate speed
- ψA: phase must
- λV: gate need

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Pattern must | Wave need |
| Human | λV | Gate need | Flow must |
| Cosmic | ψA | Phase gate | Field need |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Need fail | Pattern block | Can't get |
| Human | Gate stuck | Flow stop | Won't move |
| Cosmic | Must break | Field block | No way |

---

## Diagnostic Checklist

Technical tests:
- [ ] Need clear
- [ ] Gate works
- [ ] Order right
- [ ] Flow moves

Humane tests:
- [ ] Gets needed
- [ ] Way open
- [ ] Steps clear
- [ ] Moves well

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical dependency nor experiential need alone captures its full meaning.

---

## See Also

- [[Compatibility : Conflict (relation)]]
- [[Containment : Embedding (relation)]]
- [[Bridge : Articulation (relation)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented